<!--begin::Table-->
<table id="kt_datatable_dom_positioning" class="table table-striped table-row-bordered gy-5 gs-7 border rounded">
    <!--begin::Thead-->
    <thead>
        <tr class="fw-6 fw-semibold text-gray-600">
            <th><?php echo e(__('lang.name')); ?></th>
            <th><?php echo e(__('lang.country')); ?></th>
            <th><?php echo e(__('lang.city')); ?></th>
            <th><?php echo e(__('lang.actions')); ?></th>
        </tr>
    </thead>
    <!--end::Thead-->
    <!--begin::Tbody-->
    <tbody>
        <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td>
                    <span class="badge badge-light-success fs-7 fw-bold"><?php echo e($area->name); ?></span>
                </td>
                <td>
                    <span class="badge badge-light-success fs-7 fw-bold"><?php echo e($area->country->name); ?></span>
                </td>
                <td>
                    <span class="badge badge-light-success fs-7 fw-bold"><?php echo e($area->city->name); ?></span>
                </td>
                <td>
                    <?php if(auth()->user()->can('update areas')): ?>
                        <a href="<?php echo e(route('areas.edit', $area->id)); ?>" class="btn btn-sm btn-light me-2">
                            <i class="bi bi-pencil-square"></i>
                        </a>
                    <?php endif; ?>

                    <?php if(auth()->user()->can('delete areas')): ?>
                        <a data-url="<?php echo e(route('areas.destroy', $area->id)); ?>" type='button'
                            class="btn btn-sm btn-danger me-2 delete-btn">
                            <i class="bi bi-file-x-fill"></i>
                        </a>
                    <?php endif; ?>

                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
    <!--end::Tbody-->
</table>
<!--end::Table-->
<?php /**PATH /home/oday/public_html/mazdashboard.alialzahabia.com/resources/views/AdminPanel/areas/table.blade.php ENDPATH**/ ?>