<?php

use App\Http\Controllers\AdminPanel\AdminController;
use App\Http\Controllers\AdminPanel\AgencyController;
use App\Http\Controllers\AdminPanel\AreaController;
use App\Http\Controllers\AdminPanel\AuthController;
use App\Http\Controllers\AdminPanel\CategoryController;
use App\Http\Controllers\AdminPanel\CityController;
use App\Http\Controllers\AdminPanel\ClientController;
use App\Http\Controllers\AdminPanel\CountryController;
use App\Http\Controllers\AdminPanel\DashboardController;
use App\Http\Controllers\AdminPanel\PageController;
use App\Http\Controllers\AdminPanel\RoleController;
use App\Http\Controllers\AdminPanel\SettingsController;
use App\Http\Controllers\AdminPanel\SliderController;
use App\Http\Controllers\AdminPanel\AuctionController;
use App\Http\Controllers\AdminPanel\ArticleController;
use App\Http\Controllers\AdminPanel\FeatureController;
use App\Http\Controllers\AdminPanel\HowWeWorkController;
use App\Http\Middleware\IsSuperAdminMiddleware;
use App\Http\Controllers\AdminPanel\IntroController;
use App\Http\Controllers\AdminPanel\MessageController;
use App\Http\Controllers\AdminPanel\NotificationController;
use Illuminate\Support\Facades\Route;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

Route::group(
    [
        'prefix'     => LaravelLocalization::setLocale(),
        'middleware' => ['localeSessionRedirect', 'localizationRedirect', 'localeViewPath']
    ],
    function () {
        Route::get('add/feature/{counter}', [AuctionController::class, 'addFeature'])->name('feature.add');
        Route::get('add/attribute/{counter}', [FeatureController::class, 'addAttribute'])->name('attribute.add');
        Route::middleware(['guest'])->group(function () {
            Route::get('/', [AuthController::class, 'login'])->name('login');
            Route::post('/login', [AuthController::class, 'postLogin'])->name('post.login');
        });

        Route::middleware(['auth:web', 'isActive:web'])->group(
            function () {
                Route::get('/dashboard', DashboardController::class)->name('dashboard');

                Route::get('/logout', [AuthController::class, 'logout'])->name('logout');
                route::group(['middleware' => [IsSuperAdminMiddleware::class]], function () {
                    Route::get('roles/delete/{id}', [RoleController::class, 'destroy'])->name('roles.destroy');
                    Route::resource('roles', RoleController::class)->except(['show', 'destroy']);
                    Route::get('admins/delete/{id}', [AdminController::class, 'destroy'])->name('admins.destroy');
                    Route::resource('admins', AdminController::class)->except(['show', 'destroy']);
                });
                Route::resource('settings', SettingsController::class)->only(['index', 'store']);
                Route::resource('pages', PageController::class)->only(['index', 'edit', 'update']);

                Route::get('sliders/delete/{id}', [SliderController::class, 'destroy'])->name('sliders.destroy');
                Route::resource('sliders', SliderController::class)->except(['show', 'destroy']);

                Route::get('intro/delete/{id}', [IntroController::class, 'destroy'])->name('intro.destroy');
                Route::resource('intros', IntroController::class)->except(['show', 'destroy']);

                Route::get('categories/delete/{id}', [CategoryController::class, 'destroy'])->name('categories.destroy');
                Route::resource('categories', CategoryController::class)->except(['show', 'destroy']);

                Route::get('countries/delete/{id}', [CountryController::class, 'destroy'])->name('countries.destroy');
                Route::resource('countries', CountryController::class)->except(['show', 'destroy']);
                Route::get('cities/delete/{id}', [CityController::class, 'destroy'])->name('cities.destroy');
                Route::resource('cities', CityController::class)->except(['show', 'destroy']);
                Route::get('areas/delete/{id}', [AreaController::class, 'destroy'])->name('areas.destroy');
                Route::resource('areas', AreaController::class)->except(['show', 'destroy']);
                Route::get('clients/delete/{id}', [ClientController::class, 'destroy'])->name('clients.destroy');
                Route::resource('clients', ClientController::class)->except(['show', 'destroy']);


                Route::get('feature/auction/delete/{id}', [AuctionController::class, 'deleteFeature'])->name('feature.delete');
                Route::get('auction/delete/gallery/{id}', [AuctionController::class, 'deleteGallery'])->name('auction.deleteGallery');
                Route::get('auction/delete/image/{id}', [AuctionController::class, 'deleteImage'])->name('auction.deleteImage');
                Route::get('auction/delete/{id}', [AuctionController::class, 'destroy'])->name('auction.destroy');
                Route::resource('auctions', AuctionController::class)->except(['show', 'destory']);

                // Articles
                Route::get('articles/delete/{id}', [ArticleController::class, 'destroy'])->name('article.destroy');
                Route::resource('articles', ArticleController::class)->except(['show', 'destroy']);

                // howWeWorks
                Route::get('howwework/delete/{id}', [HowWeWorkController::class, 'destroy'])->name('howwework.destroy');
                Route::resource('howeworks', HowWeWorkController::class)->except(['show', 'destroy']);
                Route::resource('messages', MessageController::class)->only(['index', 'show']);

                //notifications
                Route::get('notifications/delete/{id}', [NotificationController::class, 'destroy'])->name('notifications.destroy');
                Route::resource('notifications', NotificationController::class)->only(['index', 'create', 'store']);

                //features

                Route::get('attribute/delete/{id}', [FeatureController::class, 'deleteAttribute'])->name('attribute.delete');
                Route::get('/feature/delete/{id}', [FeatureController::class, 'destroy'])->name('features.destroy');
                Route::resource('features', FeatureController::class)->except(['show', 'destroy']);


                // Agencies
                Route::get('agencies/delete/{id}', [AgencyController::class, 'destroy'])->name('agency.destroy');
                Route::resource('agencies', AgencyController::class)->except(['show', 'destroy']);
            }
        );
    }
);
