@extends('AdminPanel.app')
@section('content')
    <div class="row mt-2 d-flex justify-content-center">
        <div class="col-3 bg-success bg-gradient  mx-5 rounded p-5">
            <h1>{{ __('lang.active') }} {{ __('lang.clients') }}</h1>
            <span class="text-center fw-bold fs-1">{{ $activeClients }}</span>
            <i class="bi bi-person fs-2 fw-bold text-black d-flex justify-content-end align-items-start"></i>
        </div>
        <div class="col-3 bg-danger bg-gradient  mx-5 rounded p-5">
            <h1>{{ __('lang.inactive') }} {{ __('lang.clients') }}</h1>
            <span class="text-center fw-bold fs-1">{{ $inactiveClients }}</span>
            <i class="bi bi-person fs-2 fw-bold text-black d-flex justify-content-end align-items-start"></i>
        </div>
        <div class="col-3 bg-info bg-gradient  mx-5 rounded p-5">
            <h1> {{ __('lang.clients') }}</h1>
            <span class="text-center fw-bold fs-1">{{ $clients }}</span>
            <i class="bi bi-person fs-2 fw-bold text-black d-flex justify-content-end align-items-start"></i>
        </div>
        <div class="col-3 bg-success bg-gradient  mx-5 my-2 rounded p-5">
            <h1>{{ __('lang.incoming_auctions') }} </h1>
            <span class="text-center fw-bold fs-1">{{ $incoming_auctions }}</span>
            <i class="bi bi-hammer  fs-2 fw-bold text-black d-flex justify-content-end align-items-start"></i>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css">
    <div class="row mt-2">
        <canvas id="auctionChart" width="400" height="200"></canvas>
    </div>

    <script>
        const rawData = @json($auctions_data);
        const local = "{{ app()->getLocale() }}";

        function formatMonthYear(key) {
            const [year, month] = key.split("-");
            if (local == 'en') {
                var monthNames = {
                    "01": "Jan",
                    "02": "Feb",
                    "03": "Mar",
                    "04": "Apr",
                    "05": "May",
                    "06": "Jun",
                    "07": "Jul",
                    "08": "Aug",
                    "09": "Sep",
                    "10": "Oct",
                    "11": "Nov",
                    "12": "Dec"
                };
            } else {
                var monthNames = {
                    "01": "يناير",
                    "02": "فبراير",
                    "03": "مارس",
                    "04": "أبريل",
                    "05": "مايو",
                    "06": "يونيو",
                    "07": "يوليو",
                    "08": "أغسطس",
                    "09": "سبتمبر",
                    "10": "أكتوبر",
                    "11": "نوفمبر",
                    "12": "ديسمبر"
                };
            }

            return `${monthNames[month]} ${year}`;
        }

        const sortedKeys = Object.keys(rawData).sort();
        const labels = sortedKeys.map(k => formatMonthYear(k));
        const counts = sortedKeys.map(k => rawData[k]);

        const ctx = document.getElementById('auctionChart').getContext('2d');
        const chart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [{
                    label: '{{ __('lang.incoming_auctions') }}',
                    data: counts,
                    backgroundColor: 'rgba(54, 162, 235, 0.6)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1,
                }]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
@endsection
