<x-select-two name='{{ $name }}' id='feature_id_{{ $counter }}'>
    @foreach ($features as $feature)
        <option value="{{ $feature->id }}"
            {{ old('feature_id', isset($model) ? $model->feature_id : '') == $feature->id ? 'selected' : '' }}>
            {{ $feature->name }}</option>
    @endforeach
</x-select-two>


<script>
    function toggleFeature() {
        if (document.getElementById('feature_id_{{ $counter }}').value == '') {
            $('#{{ $attributeid }}').empty();
            $('#{{ $attributeid }}').append('<option>??</option>');
            return true;
        }
        $.ajax({
            url: "{{ url('api/' . App::getLocale() . '/features/') }}/" + document.getElementById(
                'feature_id_{{ $counter }}').value,
            type: 'GET',
            dataType: 'json',
            success: function(data) {
                $('#{{ $attributeid }}').empty();
                $('#{{ $attributeid }}').append('<option>??</option>');
                $.each(data.data, function(key, value) {

                    $('#{{ $attributeid }}').append('<option value="' + value.id +
                        '">' +
                        value.name + '</option>');
                })
            },
            error: function(error) {
                console.error(error);
            }
        });

    }

    $(document).on('change', '#feature_id_{{ $counter }}', toggleFeature);
    initChoices();
</script>
