<!--begin::Table-->
<table id="kt_datatable_dom_positioning" class="table table-striped table-row-bordered gy-5 gs-7 border rounded">
    <!--begin::Thead-->
    <thead>
        <tr class="fw-6 fw-semibold text-gray-600">
            <th>{{ __('lang.name') }}</th>
            <th>{{ __('lang.email') }}</th>
            <th>{{ __('lang.status') }}</th>
            <th>{{ __('lang.actions') }}</th>
        </tr>
    </thead>
    <!--end::Thead-->
    <!--begin::Tbody-->
    <tbody>
        @foreach ($clients as $client)
            <tr>
                <td>
                    <x-image-tag :url="$client->image" />
                    <span class="badge badge-light-success fs-7 fw-bold">{{ $client->name }}</span>
                </td>
                <td>{{ $client->email }}</td>
                <td>
                    <span
                        class="badge badge-light-{{ $client->status_color }} fs-7 fw-bold">{{ $client->status_text }}</span>
                </td>
                <td>
                    @if (auth()->user()->can('update clients'))
                        <a href="{{ route('clients.edit', $client->id) }}" class="btn btn-sm btn-light me-2">
                            <i class="bi bi-pencil-square"></i>
                        </a>
                    @endif
                    @if (auth()->user()->can('delete clients'))
                        <a href="{{ route('clients.destroy', $client->id) }}" class="btn btn-sm">
                            <i class="bi {{ $client->status == 1 ? 'bi-toggle-on' : 'bi-toggle-off' }}"></i>
                        </a>
                    @endif

                </td>
            </tr>
        @endforeach
    </tbody>
    <!--end::Tbody-->
</table>
<!--end::Table-->
