<!--begin::Table-->
<table id="kt_datatable_dom_positioning" class="table table-striped table-row-bordered gy-5 gs-7 border rounded">
    <!--begin::Thead-->
    <thead>
        <tr class="fw-6 fw-semibold text-gray-600">
            <th>{{ __('lang.name') }}</th>
            <th>{{ __('lang.category') }}</th>
            <th>{{ __('lang.type') }}</th>
            <th>{{ __('lang.actions') }}</th>
        </tr>
    </thead>
    <!--end::Thead-->
    <!--begin::Tbody-->
    <tbody>
        @foreach ($auctions as $auction)
            <tr>
                <td>
                    <x-image-tag :url="$auction->image"></x-image-tag>
                    <span class="badge badge-light-success fs-7 fw-bold">{{ $auction->title }}</span>
                </td>
                <td>
                    {{ $auction->category?->name }}
                </td>
                <td>
                    {{ $auction->type_text }}
                </td>
                <td>
                    @if (auth()->user()->can('update auctions'))
                        <a href="{{ route('auctions.edit', $auction->id) }}" class="btn btn-sm btn-light me-2">
                            <i class="bi bi-pencil-square"></i>
                        </a>
                    @endif

                    @if (auth()->user()->can('delete auctions'))
                        <a data-url="{{ route('auction.destroy', $auction->id) }}" type='button'
                            class="btn btn-sm btn-danger me-2 delete-btn">
                            <i class="bi bi-file-x-fill"></i>
                        </a>
                    @endif

                </td>
            </tr>
        @endforeach
    </tbody>
    <!--end::Tbody-->
</table>
<!--end::Table-->
