@isset($auction)
    @method('PUT')
    <input type="hidden" value="{{ $auction->id }}" name="id">
@endisset
@csrf
<x-localization>
    @foreach (LaravelLocalization::getSupportedLocales() as $name => $value)
        <div class="tab-pane fade {{ LaravelLocalization::getCurrentLocale() == $name ? 'show active' : '' }}"
            id="{{ $name }}" role="tabpanel" aria-labelledby="{{ $name }}-tab">

            <!--begin::Input group-->
            <div class="row mb-3">
                <!--begin::Label-->
                <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.title') }}</label>
                <!--end::Label-->

                <!--begin::Col-->
                <div class="col-lg-8">
                    <!--begin::Row-->
                    <div class="row">
                        <!--begin::Col-->
                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                            <input type='text' name="{{ $name }}[title]"
                                class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 "
                                placeholder="{{ __('lang.title') }}"
                                value="{{ old($name . '.title', isset($auction) ? $auction->translateOrNew($name)->title : '') }}">
                            <div
                                class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                            </div>
                        </div>
                        <!--end::Col-->
                    </div>
                    <!--end::Row-->
                </div>
                <!--end::Col-->
            </div>
            <!--end::Input group-->

            <!--begin::Input group-->
            <div class="row mb-3">
                <!--begin::Label-->
                <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.description') }}</label>
                <!--end::Label-->

                <!--begin::Col-->
                <div class="col-lg-8">
                    <!--begin::Row-->
                    <div class="row">
                        <!--begin::Col-->
                        <div class="col-lg-12 fv-row fv-plugins-icon-container">
                            <textarea name="{{ $name }}[description]" class="mb-3 mb-lg-0 summernote"
                                placeholder="{{ __('lang.description') }}">{{ old($name . '.description', isset($auction) ? $auction->translateOrNew($name)->description : '') }}</textarea>

                        </div>
                        <!--end::Col-->
                    </div>
                    <!--end::Row-->
                </div>
                <!--end::Col-->
            </div>
            <!--end::Input group-->

        </div>
    @endforeach
</x-localization>

{{-- Date --}}
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.date') }}</label>

    <div class="col-lg-8">
        <div class="row">
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type="date" name="date"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                    placeholder="{{ __('lang.date') }}"
                    value="{{ old('date', isset($auction) ? $auction->date : '') }}">
            </div>
        </div>
    </div>
</div>


{{-- time --}}
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.time') }}</label>

    <div class="col-lg-8">
        <div class="row">
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type="time" name="time"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                    placeholder="{{ __('lang.time') }}"
                    value="{{ old('time', isset($auction) ? $auction->time : '') }}">
            </div>
        </div>
    </div>
</div>


{{-- Expire Date --}}
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.expire_date') }}</label>

    <div class="col-lg-8">
        <div class="row">
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type="date" name="expire_date"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                    placeholder="{{ __('lang.expire_date') }}"
                    value="{{ old('expire_date', isset($auction) ? $auction->expire_date : '') }}">
            </div>
        </div>
    </div>
</div>


{{-- time --}}
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.expire_time') }}</label>

    <div class="col-lg-8">
        <div class="row">
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type="time" name="expire_time"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                    placeholder="{{ __('lang.expire_time') }}"
                    value="{{ old('expire_time', isset($auction) ? $auction->expire_time : '') }}">
            </div>
        </div>
    </div>
</div>

{{-- location --}}
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.lat') }}</label>

    <div class="col-lg-8">
        <div class="row">
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type="text" name="lat"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                    placeholder="{{ __('lang.lat') }}" value="{{ old('lat', isset($auction) ? $auction->lat : '') }}">
            </div>
        </div>
    </div>
</div>

<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.long') }}</label>

    <div class="col-lg-8">
        <div class="row">
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type="text" name="long"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                    placeholder="{{ __('lang.long') }}"
                    value="{{ old('long', isset($auction) ? $auction->long : '') }}">
            </div>
        </div>
    </div>
</div>

{{-- type
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.type') }}</label>

    <div class="col-lg-8">
        <select name="type" class="form-select form-select-lg form-select-solid">
            <option value="current" {{ old('type', $auction->type ?? '') == 'current' ? 'selected' : '' }}>
                {{ __('lang.current') }}
            </option>
            <option value="past" {{ old('type', $auction->type ?? '') == 'past' ? 'selected' : '' }}>
                {{ __('lang.past') }}
            </option>
            <option value="coming" {{ old('type', $auction->type ?? '') == 'coming' ? 'selected' : '' }}>
                {{ __('lang.coming') }}
            </option>
        </select>
    </div>
</div> --}}

{{-- المكان (place) --}}
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.place') }}</label>
    <div class="col-lg-8">
        <select name="place" id="place" class="form-select form-select-lg form-select-solid">
            <option value="online" {{ old('place', $auction->place ?? '') == 'online' ? 'selected' : '' }}>
                {{ __('lang.online') }}
            </option>
            <option value="offline" {{ old('place', $auction->place ?? '') == 'offline' ? 'selected' : '' }}>
                {{ __('lang.offline') }}
            </option>
        </select>
    </div>
</div>
{{-- القسم --}}
@php
    if (isset($auction)) {
        $model = $auction;
    } else {
        $model = new \App\Models\Auction();
    }
@endphp
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.agencies') }}</label>
    <x-agencies-select :model="$model"></x-agencies-select>
</div>
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.category') }}</label>
    <x-categories-select :model="$model"></x-categories-select>
</div>
{{-- الدولة --}} <div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.country') }}</label>
    <x-country-select :model="$model"></x-country-select>
</div>

{{-- المدينة --}}
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.city') }}</label>
    <x-city-select :model="$model"
        countryId="{{ old('country_id', $model ? $model->country_id : '') }}"></x-city-select>
</div>

{{-- المنطقة --}}
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.area') }}</label>
    <x-area-select :model="$model" cityId="{{ old('city_id', $model ? $model->city_id : '') }}"></x-area-select>
</div>
<!--begin::Input group-->
<div class="row mb-3">
    <!--begin::Label-->
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.duration') }}</label>
    <!--end::Label-->

    <!--begin::Col-->
    <div class="col-lg-8">
        <!--begin::Row-->
        <div class="row">
            <!--begin::Col-->
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type='number' name="duration"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 "
                    value="{{ old('duration', isset($auction) ? $auction->duration : 1) }}">

            </div>
            <!--end::Col-->
        </div>
        <!--end::Row-->
    </div>
    <!--end::Col-->
</div>
<!--end::Input group-->

<!--begin::Input group-->
<div class="row mb-3">
    <!--begin::Label-->
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.projects') }}</label>
    <!--end::Label-->

    <!--begin::Col-->
    <div class="col-lg-8">
        <!--begin::Row-->
        <div class="row">
            <!--begin::Col-->
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type='number' name="projects"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 "
                    value="{{ old('projects', isset($auction) ? $auction->projects : 1) }}">

            </div>
            <!--end::Col-->
        </div>
        <!--end::Row-->
    </div>
    <!--end::Col-->
</div>
<!--end::Input group-->

<!--begin::Input group-->
<div class="row mb-3">
    <!--begin::Label-->
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.entry') }}</label>
    <!--end::Label-->

    <!--begin::Col-->
    <div class="col-lg-8">
        <!--begin::Row-->
        <div class="row">
            <!--begin::Col-->
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type='number' name="entry"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 "
                    value="{{ old('entry', isset($auction) ? $auction->entry : 1) }}">

            </div>
            <!--end::Col-->
        </div>
        <!--end::Row-->
    </div>
    <!--end::Col-->
</div>
<!--end::Input group-->


<!--begin::Input group-->
<div class="row mb-3">
    <!--begin::Label-->
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.price') }}</label>
    <!--end::Label-->

    <!--begin::Col-->
    <div class="col-lg-8">
        <!--begin::Row-->
        <div class="row">
            <!--begin::Col-->
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type='number' name="price"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 "
                    value="{{ old('price', isset($auction) ? $auction->price : '') }}">

            </div>
            <!--end::Col-->
        </div>
        <!--end::Row-->
    </div>
    <!--end::Col-->
</div>
<!--end::Input group-->

<!--begin::Input group-->
<div class="row mb-3">
    <!--begin::Label-->
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.opening') }}</label>
    <!--end::Label-->

    <!--begin::Col-->
    <div class="col-lg-8">
        <!--begin::Row-->
        <div class="row">
            <!--begin::Col-->
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type='number' name="opening"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 "
                    value="{{ old('opening', isset($auction) ? $auction->opening : 1) }}">

            </div>
            <!--end::Col-->
        </div>
        <!--end::Row-->
    </div>
    <!--end::Col-->
</div>
<!--end::Input group-->

<!--begin::Input group-->
<div class="row mb-3">
    <!--begin::Label-->
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.license_number') }}</label>
    <!--end::Label-->

    <!--begin::Col-->
    <div class="col-lg-8">
        <!--begin::Row-->
        <div class="row">
            <!--begin::Col-->
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type='text' name="license_number"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0 "
                    value="{{ old('license_number', isset($auction) ? $auction->license_number : '') }}">

            </div>
            <!--end::Col-->
        </div>
        <!--end::Row-->
    </div>
    <!--end::Col-->
</div>
<!--end::Input group-->
{{-- Is Home --}}
<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.is_home') }}</label>

    <div class="col-lg-8">
        <div class="row">
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type="checkbox" name="is_home"
                    {{ old('is_home', isset($auction) ? $auction->is_home : 0) ? 'checked' : '' }}>
            </div>
        </div>
    </div>
</div>

<div class="card-body border-top p-9">


    {{-- صورة --}}
    <x-image name="image" :model="$model" label='image'></x-image>

</div>


<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.images') }}</label>

    <div class="col-lg-8">
        <div class="row">
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type="file" name="images[]" multiple accept="image/*"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0">
            </div>
        </div>
    </div>
    @if (isset($auction) && !empty($auction->images))
        <div class="d-flex justify-between m-4 gap-2">
            @foreach ($auction->images as $image)
                <div class="d-flex flex-column gap-1">
                    <x-image-tag :url="$image->image"></x-image-tag>
                    <a data-url="{{ route('auction.deleteImage', ['id' => $image->id]) }}" type='button'
                        class="btn-sm btn-danger delete-btn p-0 text-center">
                        <i class="bi bi-file-x-fill"></i>
                    </a>
                </div>
            @endforeach
        </div>
    @endif
</div>


<div class="row mb-3">
    <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.gallery') }}</label>

    <div class="col-lg-8">
        <div class="row">
            <div class="col-lg-12 fv-row fv-plugins-icon-container">
                <input type="file" name="gallery[]" multiple accept="image/*"
                    class="form-control form-control-lg form-control-solid mb-3 mb-lg-0">
            </div>
        </div>
    </div>
    @if (isset($auction) && !empty($auction->gallery))
        <div class="d-flex justify-between m-4 gap-2">
            @foreach ($auction->gallery as $gallery)
                <div class="d-flex flex-column gap-1">
                    <x-image-tag :url="$gallery->image"></x-image-tag>
                    <a data-url="{{ route('auction.deleteGallery', ['id' => $gallery->id]) }}" type='button'
                        class="btn-sm btn-danger delete-btn p-0 text-center">
                        <i class="bi bi-file-x-fill"></i>
                    </a>
                </div>
            @endforeach
        </div>
    @endif
</div>


<hr>
<div class="d-flex justify-content-center gap-2">
    <button type="button" id="add_feature" class="btn btn-sm btn-success" onclick="addFeature()">
        <i class="bi bi-plus"></i> </button>
    <h1>{{ __('lang.features') }}</h1>
</div>
<hr>
<div id="features_section">

    @isset($auction)
        @foreach ($auction->features as $feature)
            @include('AdminPanel.auctions.features', [
                'feature' => $feature,
                'counter' => $feature->id,
            ])
        @endforeach
    @endisset

</div>



<script>
    let counter = `{{ isset($auction) ? $auction->features->max('id') + 1 : 0 }}`;
    let container = document.getElementById('features_section');

    function addFeature() {
        $.ajax({
            url: "{{ url(App::getLocale() . '/add/feature') }}/" + counter,
            type: 'GET',
            success: function(data) {
                $(container).append(`${data}`);
                counter++;
            },
            error: function(error) {
                console.error(error);
            }
        });

    }

    function deleteFeature(id) {
        $(`#feature-${id}`).remove();
    }
</script>
