<!--begin::Table-->
<table id="kt_datatable_dom_positioning" class="table table-striped table-row-bordered gy-5 gs-7 border rounded">
    <!--begin::Thead-->
    <thead>
        <tr class="fw-6 fw-semibold text-gray-600">
            <th>{{ __('lang.image') }}</th>
            <th>{{ __('lang.title') }}</th>
            <th>{{ __('lang.actions') }}</th>
        </tr>
    </thead>
    <!--end::Thead-->
    <!--begin::Tbody-->
    <tbody>
        @foreach ($articles as $article)
            <tr>
                <td>
                    <x-image-tag :url="$article->image"></x-image-tag>
                </td>
                <td>
                    <span class="badge badge-light-success fs-7 fw-bold">{{ $article->title }}</span>
                </td>
                <td>
                    @if (auth()->user()->can('update articles'))
                        <a href="{{ route('articles.edit', $article->id) }}" class="btn btn-sm btn-light me-2">
                            <i class="bi bi-pencil-square"></i>
                        </a>
                    @endif

                    @if (auth()->user()->can('delete articles'))
                        <a data-url="{{ route('article.destroy', $article->id) }}" type='button'
                            class="btn btn-sm btn-danger me-2 delete-btn">
                            <i class="bi bi-file-x-fill"></i>
                        </a>
                    @endif

                </td>
            </tr>
        @endforeach
    </tbody>
    <!--end::Tbody-->
</table>
<!--end::Table-->
