@isset($agency)
    @method('PUT')
    <input type="hidden" value="{{ $agency->id }}" name="id">
@endisset
@csrf

<div class="card-body border-top p-9">
    <!--begin::Input group-->
    <div class="row mb-3">
        <!--begin::Label-->
        <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.name') }}</label>
        <!--end::Label-->

        <!--begin::Col-->
        <div class="col-lg-8">
            <!--begin::Row-->
            <div class="row">
                <!--begin::Col-->
                <div class="col-lg-12 fv-row fv-plugins-icon-container">
                    <input type='text' name="name"
                        class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                        placeholder="{{ __('lang.name') }}"
                        value="{{ old('name', isset($agency) ? $agency->name : '') }}">
                </div>
                <!--end::Col-->
            </div>
            <!--end::Row-->
        </div>
        <!--end::Col-->
    </div>
    <!--end::Input group-->


    <!--begin::Input group-->
    <div class="row mb-3">
        <!--begin::Label-->
        <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.short_description') }}</label>
        <!--end::Label-->

        <!--begin::Col-->
        <div class="col-lg-8">
            <!--begin::Row-->
            <div class="row">
                <!--begin::Col-->
                <div class="col-lg-12 fv-row fv-plugins-icon-container">
                    <textarea name="short_description" class="mb-3 mb-lg-0" rows="3" cols="75"
                        placeholder="{{ __('lang.short_description') }}">{{ old('short_description', isset($agency) ? $agency->short_description : '') }}</textarea>

                </div>
                <!--end::Col-->
            </div>
            <!--end::Row-->
        </div>
        <!--end::Col-->
    </div>
    <!--end::Input group-->

    <!--begin::Input group-->
    <div class="row mb-3">
        <!--begin::Label-->
        <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.phone') }}</label>
        <!--end::Label-->

        <!--begin::Col-->
        <div class="col-lg-8">
            <!--begin::Row-->
            <div class="row">
                <!--begin::Col-->
                <div class="col-lg-8 fv-row fv-plugins-icon-container">
                    <input type='text' name="phone"
                        class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                        placeholder="{{ __('lang.phone') }}"
                        value="{{ old('phone', isset($agency) ? $agency->phone : '') }}">
                </div>
                <!--end::Col-->
                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                    <label class="col-form-label  fw-semibold fs-6">{{ __('lang.show') }}</label>

                    <input type="checkbox" name="show_phone"
                        {{ old('show_phone', isset($agency) ? $agency->show_phone : 0) ? 'checked' : '' }}>
                </div>
            </div>
        </div>
    </div>

    <!--end::Input group-->


    <!--begin::Input group-->
    <div class="row mb-3">
        <!--begin::Label-->
        <label class="col-lg-4 col-form-label required fw-semibold fs-6">{{ __('lang.whatsapp') }}</label>
        <!--end::Label-->

        <!--begin::Col-->
        <div class="col-lg-8">
            <!--begin::Row-->
            <div class="row">
                <!--begin::Col-->
                <div class="col-lg-8 fv-row fv-plugins-icon-container">
                    <input type='text' name="whatsapp"
                        class="form-control form-control-lg form-control-solid mb-3 mb-lg-0"
                        placeholder="{{ __('lang.whatsapp') }}"
                        value="{{ old('whatsapp', isset($agency) ? $agency->whatsapp : '') }}">
                </div>
                <!--end::Col-->
                <div class="col-lg-4 fv-row fv-plugins-icon-container">
                    <label class="col-form-label  fw-semibold fs-6">{{ __('lang.show') }}</label>

                    <input type="checkbox" name="show_whatsapp"
                        {{ old('show_whatsapp', isset($agency) ? $agency->show_whatsapp : 0) ? 'checked' : '' }}>
                </div>
            </div>
        </div>
    </div>

    <!--end::Input group-->

    @php
        if (isset($agency)) {
            $model = $agency;
        } else {
            $model = new \App\Models\Agency();
        }
    @endphp
    <x-image :model="$model" label='logo'>
    </x-image>
</div>
