<!DOCTYPE html>

<html lang="{{ App::getLocale() }}">
<!--begin::Head-->

<head>
    <title>{{ __('auth.sign_in') }}</title>
    <meta charset="utf-8" />


    <link rel="shortcut icon" href="{{ $setting->image }}" />

    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Inter:300,400,500,600,700" />

    <link href="{{ asset('assets/plugins/global/plugins.bundle.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('assets/css/style.bundle.css') }}" rel="stylesheet" type="text/css" />

    <script></script>
</head>


<body id="kt_body" class="app-blank" dir="{{ app()->getLocale() == 'ar' ? 'rtl' : 'ltr' }}">
    <!--end::Theme mode setup on page load-->
    <!--begin::Root-->

    <div class="d-flex flex-column flex-root" id="kt_app_root">
        <!--begin::Authentication - Sign-in -->
        <div class="d-flex gap-2 w-full justify-around m-auto my-2 ">
            @foreach (LaravelLocalization::getSupportedLocales() as $name => $value)
                <a href="{{ LaravelLocalization::getLocalizedURL($name) }}"
                    class="btn btn-light {{ LaravelLocalization::getCurrentLocale() == $name ? 'active' : '' }}"
                    {{ LaravelLocalization::getCurrentLocale() == $name ? 'style=pointer-events:none; cursor: not-allowed' : '' }}>
                    {{ $value['native'] }}
                </a>
            @endforeach
        </div>
        <div class="d-flex flex-column flex-lg-row flex-column-fluid">
            <!--begin::Body-->
            <div class="d-flex flex-column flex-lg-row-fluid w-lg-50 p-10 order-2 order-lg-1">
                <!--begin::Form-->
                <div class="d-flex flex-center flex-column flex-lg-row-fluid">

                    <!--begin::Wrapper-->
                    <div class="w-lg-500px p-10">
                        <!--begin::Form-->
                        <form class="form w-100" method="POST" action="{{ route('post.login') }}">
                            @csrf
                            <!--begin::Heading-->
                            <div class="text-center mb-11">
                                <!--begin::Title-->
                                <h1 class="text-dark fw-bolder mb-3">{{ __('auth.sign_in') }}</h1>
                                <!--end::Title-->
                                @include('AdminPanel.partials.errors')

                            </div>
                            <!--begin::Heading-->

                            <!--begin::Input group=-->
                            <div class="fv-row mb-8">
                                <!--begin::Email-->
                                <input type="email" placeholder="{{ __('auth.email') }}" name="email"
                                    autocomplete="off" class="form-control bg-transparent" />
                                <!--end::Email-->
                            </div>
                            <!--end::Input group=-->
                            <div class="fv-row mb-3">
                                <!--begin::Password-->
                                <input type="password" placeholder="{{ __('auth.password') }}" name="password"
                                    autocomplete="off" class="form-control bg-transparent" />
                                <!--end::Password-->
                            </div>
                            <!--end::Input group=-->

                            <!--begin::Submit button-->
                            <div class="d-grid mb-10">
                                <input type="submit" class="btn btn-primary" value="{{ __('auth.sign_in') }}">
                            </div>
                            <!--end::Submit button-->
                        </form>
                        <!--end::Form-->
                    </div>
                    <!--end::Wrapper-->
                </div>
                <!--end::Form-->

            </div>
            <!--end::Body-->
            <!--begin::Aside-->
            <div
                class="d-flex align-items-center flex-lg-row-fluid w-lg-50 bgi-size-cover bgi-position-center order-1 order-lg-2">
                <img src="{{ $setting->image }}" class="w-100"
                    onerror="this.onerror=null;this.src='{{ asset('assets/media/svg/files/blank-image.svg') }}';">
            </div>
            <!--end::Aside-->
        </div>
        <!--end::Authentication - Sign-in-->
    </div>
    <!--end::Root-->
    <!--begin::Javascript-->
    <script>
        var hostUrl = "assets/";
    </script>
    <!--begin::Global Javascript Bundle(mandatory for all pages)-->
    <script src="{{ asset('assets/plugins/global/plugins.bundle.js') }}"></script>
    <script src="{{ asset('assets/js/scripts.bundle.js') }}"></script>
    <!--end::Global Javascript Bundle-->
    <!--begin::Custom Javascript(used for this page only)-->
    <script src="{{ asset('assets/js/custom/authentication/sign-in/general.js') }}"></script>
    <!--end::Custom Javascript-->
    <!--end::Javascript-->
</body>
<!--end::Body-->

</html>
