<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;

class PermissionSeeder extends Seeder
{

    public function run(): void
    {
        $permissions = [
            'view notifications',
            'create notifications',
            'update notifications',
            'delete notifications',
            'view sliders',
            'create sliders',
            'update sliders',
            'delete sliders',
            'view category',
            'create category',
            'update category',
            'delete category',
            'view auctions',
            'create auctions',
            'update auctions',
            'delete auctions',
            'view clients',
            'create clients',
            'update clients',
            'delete clients',
            'view countries',
            'create countries',
            'update countries',
            'delete countries',
            'view cities',
            'create cities',
            'update cities',
            'delete cities',
            'view areas',
            'create areas',
            'update areas',
            'delete areas',
            'view pages',
            'create pages',
            'update pages',
            'delete pages',
            'view settings',
            'create settings',
            'update settings',
            'delete settings',
            'view Intro',
            'create Intro',
            'update Intro',
            'delete Intro',
            'view articles',
            'create articles',
            'update articles',
            'delete articles',
            'view howWeWork',
            'create howWeWork',
            'update howWeWork',
            'delete howWeWork',
            'view messages',
            'create messages',
            'update messages',
            'delete messages',
            'view features',
            'create features',
            'update features',
            'delete features',
            'view agency',
            'create agency',
            'update agency',
            'delete agency',
        ];
        foreach ($permissions as $permission) {
            \Spatie\Permission\Models\Permission::updateOrCreate(['name' => $permission], ['name' => $permission]);
        }
    }
}
