<?php

namespace App\View\Components;

use App\Models\Country;
use App\Repositries\MainRepository;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class CountrySelect extends Component
{
    public $countries, $model, $countryRepository;
    public function __construct(
        $model = null,
        MainRepository $countryRepository
    ) {
        $this->model = $model;
        $this->countryRepository = $countryRepository;
        $this->countries = $this->countryRepository->index(new Country());
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.country-select');
    }
}
