<?php

namespace App\View\Components;

use App\Models\Area;
use App\Repositries\MainRepository;
use Closure;
use Illuminate\Contracts\View\View;
use Illuminate\View\Component;

class AreaSelect extends Component
{
    public $areas, $model, $areaRepository, $cityId;
    public function __construct(
        $model = null,
        MainRepository $areaRepository,
        $cityId = null
    ) {
        $this->model = $model;
        $this->areaRepository = $areaRepository;
        $this->cityId = $cityId;
        $this->areas =  $this->cityId ? $this->areaRepository->index(Area::where('city_id', $this->cityId)) : [];
    }
    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View|Closure|string
    {
        return view('components.area-select');
    }
}
