<?php

namespace App\Repositries;

use App\Models\Slider;

class SliderRepository
{
    public $mainRepositry;
    public $model;
    public function __construct(MainRepository $mainRepositry, Slider $model)
    {
        $this->mainRepositry = $mainRepositry;
        $this->model         = $model;
    }

    public function index()
    {
        $sliders = $this->model->query();
        return $this->mainRepositry->index($sliders)->sortBy('order');
    }

    public function show($id)
    {
        $slider = $this->mainRepositry->show($this->model, $id);
        return $slider;
    }

    public function store($data)
    {
        $slider = $this->mainRepositry->create($this->model, $data);
        $slider->update($data);
        return $slider;
    }

    public function update($id, $data)
    {
        $slider            = $this->mainRepositry->update($this->model, $id, $data);
        return $slider;
    }

    public function destroy($id)
    {
        $this->mainRepositry->destroy($this->model, $id);
    }
}
