<?php

namespace App\Repositries;

use App\Interfaces\ChangeStatusInterface;
use App\Interfaces\DeleteInterface;
use App\Interfaces\MainInterface;
use Astrotomic\Translatable\Contracts\Translatable as TranslatableContract;

class MainRepository implements MainInterface, DeleteInterface, ChangeStatusInterface
{
    public function index($model)
    {
        return request()->per_page ? $model->paginate(request()->per_page) : $model->get();
    }

    public function show($model, $id)
    {
        return $model->findOrFail($id);
    }

    public function create($model, $data)
    {
        return $model->create($data);
    }


    public function update($model, $id, $data)
    {
        $instance = $this->show($model, $id);
        $instance->update($data);
        return $instance;
    }

    public function destroy($model, $id)
    {
        $instance = $this->show($model, $id);
        return $instance->delete();
    }

    public function changeStatus($model, $id)
    {
        $instance = $this->show($model, $id);
        $instance->status = $instance->status == '0' ? '1' : '0';
        $instance->save();
        return $instance;
    }
}
