<?php

namespace App\Repositries;

use App\Models\Feature;

class FeatureRepository
{
    public $mainRepositry;
    public $model;
    public function __construct(MainRepository $mainRepositry, Feature $model)
    {
        $this->mainRepositry = $mainRepositry;
        $this->model         = $model;
    }

    public function index()
    {
        $features = $this->model->query();
        return $this->mainRepositry->index($features);
    }

    public function show($id)
    {
        $feature = $this->mainRepositry->show($this->model, $id)->load('attributes');
        return $feature;
    }

    public function store($data)
    {
        $feature = $this->mainRepositry->create($this->model, $data);
        $this->addAttributes($feature, $data['attributes']);
        return $feature;
    }

    public function update($id, $data)
    {
        $feature = $this->mainRepositry->update($this->model, $id, $data);
        $this->addAttributes($feature, $data['attributes']);
        return $feature;
    }

    public function destroy($id)
    {
        $this->mainRepositry->destroy($this->model, $id);
    }

    private function addAttributes($feature, $attributes = [])
    {
        foreach ($attributes as $attribute) {
            $feature->attributes()->updateOrCreate([
                'id' => $attribute['id'] ?? Null,
            ], $attribute);
        }
    }
}
