<?php

namespace App\Repositries;

use App\Models\Category;

class CategoryRepository
{
    public $mainRepositry;
    public $model;
    public function __construct(MainRepository $mainRepositry, Category $model)
    {
        $this->mainRepositry = $mainRepositry;
        $this->model         = $model;
    }

    public function index()
    {
        $categories = $this->model->query();
        return $this->mainRepositry->index($categories);
    }

    public function show($id)
    {
        $category = $this->mainRepositry->show($this->model, $id);
        return $category;
    }

    public function store($data)
    {
        $category = $this->mainRepositry->create($this->model, $data);
        return $category;
    }

    public function update($id, $data)
    {
        $data['category_id'] = $data['category_id'] ?? Null;
        $category            = $this->mainRepositry->update($this->model, $id, $data);
        return $category;
    }

    public function destroy($id)
    {
        $this->mainRepositry->destroy($this->model, $id);
    }
}
