<?php

namespace App\Repositries;

use App\Models\Agency;

class  AgencyRepository
{
    public $mainRepositry;
    public $model;

    public function __construct(MainRepository $mainRepositry, Agency $model)
    {
        $this->mainRepositry = $mainRepositry;
        $this->model         = $model;
    }

    public function index()
    {
        return $this->mainRepositry->index($this->model);
    }

    public function show($id)
    {
        return  $this->mainRepositry->show($this->model, $id);
    }

    public function store($data)
    {
        $data = $this->checkShow($data);
        return  $this->mainRepositry->create($this->model, $data);
    }

    public function update($id, $data)
    {
        $data = $this->checkShow($data);
        return $this->mainRepositry->update($this->model, $id, $data);
    }

    public function destroy($id)
    {
        $this->mainRepositry->destroy($this->model, $id);
    }

    private function checkShow($data)
    {
        $data['show_phone'] =  isset($data['show_phone']) && $data['show_phone'] ? true : false;
        $data['show_whatsapp'] =  isset($data['show_whatsapp']) && $data['show_whatsapp'] ? true : false;
        return $data;
    }
}
