<?php

namespace App\Providers;

use App\Models\ContactUs;
use App\Models\Setting;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        View::composer([
            'AdminPanel.layouts.header',
            'AdminPanel.layouts.menu',
            'AdminPanel.Authentication.login',
            'AdminPanel.app',
            'mail.otp',
            'mail.verificationCode',
        ], function ($view) {
            $setting   = Setting::first();
            if ($view->getName() == 'AdminPanel.layouts.menu') {
                $setting->messages = ContactUs::where('seen', '0')->count();
            }
            $view->with('setting', $setting);
        });
    }
}
