<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Http\Traits\ImageTrait;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Astrotomic\Translatable\Translatable;

class Slider extends Model
{
    use ImageTrait , Translatable;
    protected $fillable             = [ 'image',   'order', 'position' ];
    public $translatedAttributes    = ['title'];
    protected $folder               = 'sliders';

    public static function rules()
    {
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $local) {
            $rules[ $local .  '.title' ] = 'required|string|max:255';
        }
        $rules['image']         = 'image|mimes:png,jpg,jpeg|max:2048|';
        $rules['order']         = 'nullable|numeric';
        $rules['position']      = 'nullable|in:top,bottom,center';
        return $rules;
    }
}
