<?php

namespace App\Models;

use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use  Translatable;
    public $translatedAttributes = ['title', 'body'];

    protected $fillable = [
        'title',
        'body',
        'client_id',
        'notifiable_type',
        'notifiable_id',
        'admin_notification_id',
    ];


    public function notifiable()
    {
        return $this->morphTo();
    }
}
