<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Http\Traits\ImageTrait;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Astrotomic\Translatable\Translatable;

class Intro extends Model
{
    use ImageTrait , Translatable;
    protected $fillable             = [ 'image' ];
    public $translatedAttributes    = ['title' , 'description'];
    protected $folder               = 'intro';

    public static function rules()
    {
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $locale) {
            $rules[ $locale .'.title' ]         = 'required|string';
            $rules[ $locale .'.description' ]   = 'required|string';
        }
        $rules['image']         = 'image|mimes:png,jpg,jpeg|max:2048|';
        return $rules;
    }
}
