<?php

namespace App\Models;

use App\Http\Traits\ImageTrait;
use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;

class FeatureAttribute extends Model
{
    use Translatable, ImageTrait;
    protected $folder = 'attributes';
    protected $fillable = [
        'name',
        'feature_id',
        'image'
    ];

    protected $translatedAttributes = [
        'name',
    ];

    public function feature()
    {
        return $this->belongsTo(Feature::class);
    }
}
