<?php

namespace App\Models;

use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Validation\Rule;
use LaravelLocalization;

class Feature extends Model
{
    use Translatable;

    protected $fillable = ['name'];

    protected $translatedAttributes = ['name'];

    public static function rules()
    {
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $local) {
            $rules[$local .  '.name'] = 'required|string|max:255';
            $rules['attributes.*.id'] = 'sometimes';
            $rules['attributes.*.' . $local .  '.name'] = 'required|string|max:255';
            $rules['attributes.*.image'] = 'image|mimes:jpg,png,jpeg|required_without:attributes.*.id';
        }
        $rules['attributes'] =  [Rule::requiredIf(!request()->feature), 'array', 'min:1'];
        return $rules;
    }


    public function attributes()
    {
        return $this->hasMany(FeatureAttribute::class);
    }
}
