<?php

namespace App\Models;

use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class Country extends Model
{
    use Translatable;
    protected $fillable             = ['name', 'id'];
    public $translatedAttributes    = ['name'];

    public static function rules()
    {
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $locale) {
            $rules[$locale . '.name'] = 'required|string';
        }
        return $rules;
    }

    public function cities()
    {
        return $this->hasMany(City::class);
    }
}
