<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Astrotomic\Translatable\Translatable;

class City extends Model
{
    use Translatable;
    protected $fillable             = ['name', 'country_id', 'id'];
    public $translatedAttributes    = ['name'];

    public static function rules()
    {
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $local) {
            $rules[$local .  '.name']   = 'required|string|max:255';
        }
        $rules['country_id']    = 'required|exists:countries,id';
        return $rules;
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function areas()
    {
        return $this->hasMany(Area::class);
    }
}
