<?php

namespace App\Models;

use App\Http\Traits\ImageTrait;
use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Astrotomic\Translatable\Translatable;


class Category extends Model
{
    use Translatable, ImageTrait;

    public $folder                  = 'categories';
    protected $fillable             = ['image'];
    public $translatedAttributes    = ['name'];

    public static function  rules()
    {
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $local) {
            $rules[$local .  '.name'] = 'required|string|max:255';
        }
        $rules['image']                = 'image|mimes:jpg,jpeg,png,gif,svg|max:3072|';
        return $rules;
    }

    public function auctions()
    {
        return $this->hasMany(Auction::class);
    }
}
