<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Astrotomic\Translatable\Translatable;
use App\Http\Traits\ImageTrait;

class Article extends Model
{
    use  Translatable , ImageTrait;
    protected $table                = 'articles';
    protected $fillable             = ['image'];
    public $translatedAttributes    = ['title' , 'description'];
    protected $folder               = 'articles';

    public static function rules()
    {
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $locale) {
            $rules[ $locale .  '.title' ]           = 'required|string|max:255';
            $rules[ $locale .  '.description' ]     = 'required|string';
        }
            $rules['image']         = 'image|mimes:png,jpg,jpeg|max:2048|';
        return $rules;
    }

}
