<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Astrotomic\Translatable\Translatable;

class Area extends Model
{
    use  Translatable;
    protected $fillable             = ['city_id',  'country_id', 'id'];
    public $translatedAttributes    = ['name'];

    public static function rules()
    {
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $locale) {
            $rules[$locale .  '.name'] = 'required|string|max:255';
        }
        $rules['country_id'] = 'required|exists:countries,id';
        $rules['city_id']    = 'required|';
        return $rules;
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }
}
