<?php

namespace App\Models;

use App\Http\Traits\ImageTrait;
use Illuminate\Database\Eloquent\Model;

class Agency extends Model
{
    use ImageTrait;

    protected $folder = 'agencies';

    protected $fillable = [
        'image',
        'name',
        'short_description',
        'phone',
        'whatsapp',
        'show_phone',
        'show_whatsapp',
    ];

    public static function rules()
    {
        return [
            'image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048|',
            'name' => 'required|string|max:255',
            'short_description' => 'required|string',
            'phone' => 'required|string|regex:/^([0-9\s\-\+\(\)]*)$/',
            'whatsapp' => 'required|string|regex:/^([0-9\s\-\+\(\)]*)$/',
            'show_phone' => 'nullable',
            'show_whatsapp' => 'nullable',
        ];
    }

    public function getPhoneAttribute()
    {
        if (!auth()->guard('web')->check()) {
            if ($this->attributes['show_phone']) {
                return $this->attributes['phone'];
            }
            return null;
        }
        return $this->attributes['phone'];
    }

    public function getWhatsappAttribute()
    {
        if (!auth()->guard('web')->check()) {
            if ($this->attributes['show_whatsapp']) {
                return $this->attributes['whatsapp'];
            }
            return null;
        }
        return $this->attributes['whatsapp'];
    }
}
