<?php

namespace App\Models;

use Astrotomic\Translatable\Translatable;
use Illuminate\Database\Eloquent\Model;
use LaravelLocalization;

class AdminNotification extends Model
{
    use Translatable;

    public $translatedAttributes = ['title', 'body'];

    protected $fillable = [
        'title',
        'body',
    ];

    public static function rules()
    {
        foreach (LaravelLocalization::getSupportedLanguagesKeys() as $locale) {
            $rules[$locale . '.title'] = 'required|string|min:3|max:255';
            $rules[$locale . '.body'] = 'required|string|min:3|max:255';
        }
        $rules['client_id'] = 'required|array|min:1';
        return $rules;
    }
}
