<?php

namespace App\Jobs;

use App\Http\Traits\FireBaseTrait;
use App\Models\Notification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Support\Facades\Log;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class SendNotificationJob implements ShouldQueue
{
    use Queueable, Dispatchable, FireBaseTrait;

    protected  $users;
    protected  $data;
    protected $type;
    protected $model;
    protected $notifiable_type;
    protected $notifiable_id;
    public function __construct($users, $data, $type, $model, $notifiable_type = null, $notifiable_id = null)
    {
        $this->users = $users;
        $this->data = $data;
        $this->type = $type;
        $this->model = $model;
        $this->notifiable_type = $notifiable_type;
        $this->notifiable_id = $notifiable_id;
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        try {
            foreach ($this->users as $user) {
                $notification = [];
                foreach (LaravelLocalization::getSupportedLanguagesKeys() as $locale) {
                    $notification[$locale] = [
                        'title' => $this->data[$locale]['title'],
                        'body'  => $this->data[$locale]['body'],
                    ];
                }
                $notification[strtolower($this->type) . '_id']      = $user;
                $notification['notifiable_type'] = $this->notifiable_type ?? 'App\\Models\\' . $this->type;
                $notification['notifiable_id'] = $this->notifiable_id ?? $user;
                $notification['admin_notification_id'] = $this->data['amdin_notification_id'] ?? null;
                $record = $this->model->find($user);

                $notification = Notification::create($notification);

                if ($record && $record->fcm_token) {
                    $this->send((array)$record->fcm_token, $notification);
                }
            }
        } catch (\Exception $e) {
            Log::error($e->getMessage());
        }
    }
}
