<?php

namespace App\Http\Traits;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

trait ValidationTrait
{
    use ResponseTrait;
    public function failedValidation(Validator $validator)
    {
        throw new HttpResponseException(
            $this->response('failed', $validator->errors()->first(), [], 422)
        );
    }
}
