<?php

namespace App\Http\Traits;

trait StatusTrait
{
    public function getStatusTextAttribute()
    {
        return isset($this->attributes['status']) &&
            $this->attributes['status'] == '0' ? __('lang.inactive') : __('lang.active');
    }


    public function getStatusColorAttribute()
    {
        return isset($this->attributes['status']) &&
            $this->attributes['status'] == '0' ? 'danger' : 'success';
    }

    public function scopeActive($query)
    {
        return $query->where('status', '1');
    }
}
