<?php

namespace App\Http\Resources\Auction;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AuctionFeatureResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            "name" => $this->feature->name,
            'attributes' => AuctionFeatureAttributeResource::collection($this->auction->features()->where('feature_id', $this->feature_id)->get()),
        ];
    }
}
