<?php

namespace App\Http\Requests\Admin\Auction;

use Illuminate\Foundation\Http\FormRequest;
use App\Models\Auction;
use App\Repositries\AuctionRepository;

class AuctionUpdateRequest extends FormRequest
{
    public $auction;
    public function __construct(AuctionRepository $auctionRepository)
    {
        $this->auction = $auctionRepository->show(request()->id);
    }

    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $imagesMax = 3 - $this->auction->images()->count();
        $rules = Auction::rules();
        $rules['images'] .= 'max:' . $imagesMax;
        return $rules;
    }
}
