<?php

namespace App\Http\Requests\API\Profile;

use App\Http\Traits\ValidationTrait;
use Illuminate\Foundation\Http\FormRequest;

class UpdateProfileRequest extends FormRequest
{
    use ValidationTrait;
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules['name'] = "sometimes";
        $rules['email'] = "sometimes|unique:" . ($this->guard == 'web' ? 'user' : $this->guard) . "s,email," . auth($this->guard)->user()->id;
        $rules['image'] = 'sometimes|mimes:png,jpg,jpeg|image';
        if ($this->guard == 'designer') {
            $rules['bio'] = 'nullable|string';
            $rules['about'] = 'nullable|string';
            $rules['video_url'] = [
                'nullable',
                'url',
                'regex:/^(https?:\/\/)?(www\.)?(youtube\.com\/watch\?v=|youtu\.be\/)[\w\-]+(\?[\w=&]+)?$/'
            ];
        }
        return $rules;
    }
}
