<?php

namespace App\Http\Requests\API\Authentication;

use App\Http\Traits\ValidationTrait;
use App\Models\Client;
use Illuminate\Foundation\Http\FormRequest;

class SignUpRequest extends FormRequest
{
    use ValidationTrait;
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = Client::rules();
        $rules['password'] .= 'required';
        return $rules;
    }
}
