<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;
use Symfony\Component\HttpFoundation\Response;

class SetApiLocale
{

    public function handle(Request $request, Closure $next): Response
    {
        $locale = $request->route('local') ?? config('app.locale');
        LaravelLocalization::setLocale($locale);

        $request->route()->forgetParameter('local');
        return $next($request);
    }
}
