<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Slider\SliderCreateRequest;
use App\Http\Requests\Admin\Slider\SliderUpdateRequest;
use App\Models\Slider;
use App\Http\Traits\ToasterTrait;
use App\Repositries\SliderRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class SliderController extends Controller implements HasMiddleware
{
    use ToasterTrait;
    public $slider, $sliderRepository;
    public function __construct(SliderRepository $sliderRepository, Slider $slider)
    {
        $this->slider           = $slider;
        $this->sliderRepository = $sliderRepository;
    }

    public static function middleware()
    {
        return [
            new Middleware('permission:view sliders', only: ['index']),
            new Middleware('permission:create sliders', only: ['create', 'store']),
            new Middleware('permission:update sliders', only: ['edit', 'update']),
            new Middleware('permission:delete sliders', only: ['destroy']),
        ];
    }

    public function index()
    {
        $sliders = $this->sliderRepository->index($this->slider);
        return view('AdminPanel.sliders.index',  get_defined_vars());
    }

    public function create()
    {
        return view('AdminPanel.sliders.create');
    }

    public function store(SliderCreateRequest $request)
    {
        $data = $request->validated();
        $this->sliderRepository->store($data);
        $this->success(__('lang.created'));
        return redirect()->route('sliders.index');
    }

    public function edit(string $id)
    {
        $slider = $this->sliderRepository->show($id);
        return view('AdminPanel.sliders.edit', get_defined_vars());
    }

    public function update(SliderUpdateRequest $request, string $id)
    {
        $data   = $request->validated();
        $slider = $this->sliderRepository->update($id, $data);
        $this->success(__('lang.updated'));
        return redirect()->route('sliders.index');
    }

    public function destroy(string $id)
    {
        $this->sliderRepository->destroy($id);
        $this->success(__('lang.deleted'));
        return redirect()->route('sliders.index');
    }
}
