<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Setting\SettingRequest;
use App\Http\Traits\ToasterTrait;
use App\Models\Setting;
use App\Repositries\MainRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class SettingsController extends Controller implements HasMiddleware
{
    use ToasterTrait;
    public $settingRepository, $setting;
    public function __construct(MainRepository $settingRepository, Setting $setting)
    {
        $this->settingRepository = $settingRepository;
        $this->setting = $setting;
    }

    public static function middleware()
    {
        return [
            new Middleware('permission:view settings', only: ['index']),
            new Middleware('permission:update settings', only: ['store']),
        ];
    }

    public function index()
    {
        $settings = $this->settingRepository->show($this->setting, $id = 1);
        return view("AdminPanel.settings.edit", get_defined_vars());
    }

    public function store(SettingRequest $request)
    {
        $this->settingRepository->update($this->setting, $id = 1, $request->validated());
        $this->success(__('lang.updated'));
        return redirect()->route("settings.index");
    }
}
