<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Notification\NotificationRequest;
use App\Http\Traits\ToasterTrait;
use App\Repositries\ClientRepository;
use App\Repositries\NotificationRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class NotificationController extends Controller implements HasMiddleware

{
    use ToasterTrait;
    public $notificationRepository, $clientRepository;
    public static function middleware()
    {
        return [
            new Middleware('permission:view notifications', only: ['index', 'show']),
            new Middleware('permission:create notifications', only: ['create', 'store']),
            new Middleware('permission:update notifications', only: ['edit', 'update']),
            new Middleware('permission:delete notifications', only: ['destroy']),
        ];
    }

    public function __construct(NotificationRepository $notificationRepository, ClientRepository $clientRepository)
    {
        $this->notificationRepository = $notificationRepository;
        $this->clientRepository = $clientRepository;
    }

    public function index()
    {
        $notifications = $this->notificationRepository->index(request()->per_page);

        return view('AdminPanel.notifications.index', get_defined_vars());
    }

    public function create()
    {
        $clients = $this->clientRepository->index();
        return view('AdminPanel.notifications.create', get_defined_vars());
    }

    public function store(NotificationRequest $request)
    {
        $data = $request->validated();
        $notification = $this->notificationRepository->store($data);
        $this->success(__('lang.created'));
        return redirect()->route('notifications.index');
    }


    public function destroy(string $id)
    {
        $this->notificationRepository->destroy($id);

        $this->success(__('lang.deleted'));
        return redirect()->route('notifications.index');
    }
}
