<?php

namespace App\Http\Controllers\AdminPanel;

use App\Models\Intro;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Intro\CreateIntroRequest;
use App\Http\Requests\Admin\Intro\UpdateIntroRequest;
use App\Http\Traits\ToasterTrait;
use App\Repositries\IntroRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;


class IntroController extends Controller  implements HasMiddleware
{
    use ToasterTrait;
    public $intro, $introRepository;
    public function __construct(IntroRepository $introRepository, Intro $intro)
    {
        $this->intro           = $intro;
        $this->introRepository = $introRepository;
    }

    public static function middleware()
    {
        return [
            new Middleware('permission:view Intro', only: ['index']),
            new Middleware('permission:create Intro', only: ['create', 'store']),
            new Middleware('permission:update Intro', only: ['edit', 'update']),
            new Middleware('permission:delete Intro', only: ['destroy']),
        ];
    }

    public function index()
    {
        $intros = $this->introRepository->index($this->intro);
        return view('AdminPanel.intros.index',  get_defined_vars());
    }

    public function create()
    {
        return view('AdminPanel.intros.create');
    }

    public function store(CreateIntroRequest $request)
    {
        // return $request;
        $data = $request->validated();
        $this->introRepository->store($data);
        $this->success(__('lang.created'));
        return redirect()->route('intros.index');
    }

    public function edit(string $id)
    {
        $intro = $this->introRepository->show($id);
        return view('AdminPanel.intros.edit', get_defined_vars());
    }

    public function update(UpdateIntroRequest $request, string $id)
    {
        $data = $request->validated();
        $this->introRepository->update($id, $data);
        $this->success(__('lang.updated'));
        return redirect()->route('intros.index');
    }

    public function destroy(string $id)
    {
        $this->introRepository->destroy($id);
        $this->success(__('lang.deleted'));
        return redirect()->route('intros.index');
    }
}
