<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Feature\FeatureRequest;
use App\Http\Traits\ToasterTrait;
use App\Models\FeatureAttribute;
use App\Repositries\FeatureRepository;
use App\Repositries\MainRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class FeatureController extends Controller implements HasMiddleware
{
    use ToasterTrait;
    public  $featureRepository, $attributeRepository;
    public function __construct(FeatureRepository $featureRepository, MainRepository $attributeRepository)
    {
        $this->featureRepository = $featureRepository;
        $this->attributeRepository = $attributeRepository;
    }

    public static function middleware()
    {
        return [
            new Middleware('permission:view features', only: ['index']),
            new Middleware('permission:create features', only: ['create', 'store']),
            new Middleware('permission:update features', only: ['edit', 'update']),
            new Middleware('permission:delete features', only: ['destroy']),
        ];
    }

    public function index()
    {
        $features = $this->featureRepository->index();
        return view('AdminPanel.features.index', get_defined_vars());
    }


    public function create()
    {
        return view('AdminPanel.features.create', get_defined_vars());
    }

    public function store(FeatureRequest $request)
    {
        $data = $request->validated();
        $this->featureRepository->store($data);
        $this->success(__('lang.created'));
        return redirect()->route('features.index');
    }

    public function edit(string $id)
    {
        $feature = $this->featureRepository->show($id);
        return view('AdminPanel.features.edit', get_defined_vars());
    }


    public function update(FeatureRequest $request, string $id)
    {

        $data     = $request->validated();
        $feature = $this->featureRepository->update($id, $data);

        $this->success(__('lang.updated'));

        return redirect()->route('features.index');
    }

    public function destroy(string $id)
    {
        $this->featureRepository->destroy($id);
        $this->success(__('lang.deleted'));
        return redirect()->route('features.index');
    }

    public function deleteAttribute($id)
    {
        $feature = $this->attributeRepository->show(new FeatureAttribute(), $id)->feature;
        if ($feature->attributes()->count() == 1) {
            $this->error(__('lang.cant_delete'));
        } else {
            $this->attributeRepository->destroy(new FeatureAttribute(), $id);
            $this->success(__('lang.deleted'));
        }
        return redirect()->back();
    }

    public function addAttribute($counter)
    {
        return view('AdminPanel.features.attributes', get_defined_vars())->render();
    }
}
