<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Models\Auction;
use App\Models\Client;
use App\Repositries\MainRepository;
use Carbon\Carbon;

class DashboardController extends Controller
{
    public $dashboardRepository;

    public function __construct(MainRepository $dashboardRepository)
    {
        $this->dashboardRepository = $dashboardRepository;
    }

    public function __invoke()
    {
        $activeClients = Client::where('status', '1')->count();
        $inactiveClients = Client::where('status', '0')->count();
        $clients = Client::count();
        $incoming_auctions = Auction::whereDate('date', '>=', today())->count();
        $auctions_data = Auction::whereDate('date', '>=', today())->get()->groupBy(function ($q) {
            return Carbon::parse($q->date)->format('Y-m');
        })->map(function ($q) {
            return $q->count();
        });
        return view('welcome', get_defined_vars());
    }
}
