<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Category\CategoryCreateRequest;
use App\Http\Requests\Admin\Category\CategoryUpdateRequest;
use App\Http\Traits\ToasterTrait;
use App\Repositries\CategoryRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class CategoryController extends Controller implements HasMiddleware
{
    use ToasterTrait;
    public  $categoryRepository;
    public function __construct(CategoryRepository $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    public static function middleware()
    {
        return [
            new Middleware('permission:view category', only: ['index']),
            new Middleware('permission:create category', only: ['create', 'store']),
            new Middleware('permission:update category', only: ['edit', 'update']),
            new Middleware('permission:delete category', only: ['destroy']),
        ];
    }

    public function index()
    {
        $categories = $this->categoryRepository->index();
        return view('AdminPanel.categories.index', get_defined_vars());
    }


    public function create()
    {
        $parents = $this->categoryRepository->index(1);
        return view('AdminPanel.categories.create', get_defined_vars());
    }

    public function store(CategoryCreateRequest $request)
    {
        $data = $request->validated();
        // dd($data);
        $this->categoryRepository->store($data);
        $this->success(__('lang.created'));
        return redirect()->route('categories.index');
    }

    public function edit(string $id)
    {
        $category = $this->categoryRepository->show($id);
        // return $category;
        return view('AdminPanel.categories.edit', get_defined_vars());
    }


    public function update(CategoryUpdateRequest $request, string $id)
    {

        $data     = $request->validated();
        $category = $this->categoryRepository->update($id, $data);

        $this->success(__('lang.updated'));

        return redirect()->route('categories.index');
    }

    public function destroy(string $id)
    {
        $this->categoryRepository->destroy($id);
        $this->success(__('lang.deleted'));
        return redirect()->route('categories.index');
    }
}
