<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Auction\AuctionCreateRequest;
use App\Http\Requests\Admin\Auction\AuctionUpdateRequest;
use App\Repositries\AuctionRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;
use App\Http\Traits\ToasterTrait;
use App\Models\Country;
use App\Models\AuctionFeature;
use App\Models\Category;
use App\Repositries\MainRepository;

class AuctionController extends Controller implements HasMiddleware
{
    public static function middleware()
    {
        return [
            new Middleware('permission:view auctions', only: ['index']),
            new Middleware('permission:create auctions', only: ['create', 'store']),
            new Middleware('permission:update auctions', only: ['edit', 'update']),
            new Middleware('permission:delete auctions', only: ['destroy']),
        ];
    }

    use ToasterTrait;
    public  $auctionRepository, $countries, $categories, $mainRepository;
    public function __construct(AuctionRepository $auctionRepository, MainRepository $mainRepository)
    {
        $this->auctionRepository = $auctionRepository;
        $this->categories        = $mainRepository->index(new Category());
        $this->countries         = $mainRepository->index(new Country());
        $this->mainRepository    = $mainRepository;
    }

    public function index()
    {
        $auctions = $this->auctionRepository->index();
        return view('AdminPanel.auctions.index', get_defined_vars());
    }

    public function create()
    {
        $countries = $this->countries;
        $categories = $this->categories;
        return  view('AdminPanel.auctions.create', get_defined_vars());
    }

    public function store(AuctionCreateRequest  $request)
    {
        $data = $request->validated();
        $this->auctionRepository->store($data);
        $this->success(__('lang.created'));
        return redirect()->route('auctions.index');
    }

    public function edit(string $id)
    {
        $auction        = $this->auctionRepository->show($id);
        $countries      = $this->countries;
        $categories     = $this->categories;
        return view('AdminPanel.auctions.edit', get_defined_vars());
    }

    public function update(AuctionUpdateRequest $request, string $id)
    {
        $data     = $request->validated();
        $this->auctionRepository->update($id, $data);
        $this->success(__('lang.updated'));
        return redirect()->route('auctions.index');
    }

    public function destroy(string $id)
    {
        $this->auctionRepository->destroy($id);
        $this->success(__('lang.deleted'));
        return redirect()->route('auctions.index');
    }

    public function deleteImage(string $id)
    {
        $this->auctionRepository->deleteImage($id);
        $this->success(__('lang.deleted'));
        return redirect()->back();
    }

    public function deleteGallery(string $id)
    {
        $this->auctionRepository->deleteGallery($id);
        $this->success(__('lang.deleted'));
        return redirect()->back();
    }

    public function deleteFeature($id)
    {
        $auction = $this->mainRepository->show(new AuctionFeature(), $id)->auction;
        if ($auction->features()->count() == 1) {
            $this->error(__('lang.cant_delete'));
        } else {
            $this->mainRepository->destroy(new AuctionFeature(), $id);
            $this->success(__('lang.deleted'));
        }
        return redirect()->back();
    }

    public function addFeature($counter)
    {
        return view('AdminPanel.auctions.features', get_defined_vars())->render();
    }
}
