<?php

namespace App\Http\Controllers\AdminPanel;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\Agency\AgencyCreateRequest;
use App\Http\Requests\Admin\Agency\AgencyUpdateRequest;
use App\Http\Traits\ToasterTrait;
use App\Models\Agency;
use App\Repositries\AgencyRepository;
use Illuminate\Routing\Controllers\HasMiddleware;
use Illuminate\Routing\Controllers\Middleware;

class AgencyController extends Controller implements HasMiddleware
{
    use ToasterTrait;
    public $agency, $agencyRepository;

    public static function middleware()
    {
        return [
            new Middleware('permission:view agency', only: ['index']),
            new Middleware('permission:create agency', only: ['create', 'store']),
            new Middleware('permission:update agency', only: ['edit', 'update']),
            new Middleware('permission:delete agency', only: ['destroy']),
        ];
    }


    public function __construct(AgencyRepository $agencyRepository, Agency $agency)
    {
        $this->$agency           = $agency;
        $this->agencyRepository   = $agencyRepository;
    }

    public function index()
    {
        $agencies = $this->agencyRepository->index($this->agency);
        return view('AdminPanel.agencies.index', get_defined_vars());
    }

    public function create()
    {
        return view('AdminPanel.agencies.create');
    }

    public function store(AgencyCreateRequest $request)
    {
        $data = $request->validated();
        $this->agencyRepository->store($data);
        $this->success(__('lang.created'));
        return redirect()->route('agencies.index');
    }

    public function edit(string $id)
    {
          $agency = $this->agencyRepository->show($id);
        return view('AdminPanel.agencies.edit', get_defined_vars());
    }

    public function update(AgencyUpdateRequest $request, string $id)
    {
        $data    = $request->validated();
        $this->agencyRepository->update($id, $data);
        $this->success(__('lang.updated'));
        return redirect()->route('agencies.index');
    }

    public function destroy(string $id)
    {
        $this->agencyRepository->destroy($id);
        $this->success(__('lang.deleted'));
        return redirect()->route('agencies.index');
    }
}
