<?php

namespace App\Http\Controllers\API\Slider;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;
use App\Models\Slider;
use App\Repositries\SliderRepository;

class SliderController extends Controller
{
    use ResponseTrait;
    public $sliderRepository;

    public function __construct(SliderRepository $sliderRepository)
    {
        $this->sliderRepository = $sliderRepository;
    }

    public function index()
    {
        $sliders = $this->sliderRepository->index();
        return $this->response(
            data: $sliders
        );
    }

    public function show(string $id)
    {
        $slider = $this->sliderRepository->show($id);

        return $this->response(
            data: $slider
        );
    }
}
