<?php

namespace App\Http\Controllers\API\Notification;

use App\Http\Controllers\Controller;
use App\Http\Traits\ResponseTrait;

class NotificationController extends Controller
{
    use ResponseTrait;
    public function index()
    {

        $notifications = auth('client')->user()->notifications()->with('notifiable')->orderBy('created_at', 'DESC')->cursorPaginate(request()->per_page ?? 10);

        return $this->response(data: $notifications);
    }
    public function show($id)
    {

        $notification = auth('client')->user()->notifications()->with('notifiable')->findOrFail($id);
        $notification->seen = '1';
        $notification->save();

        return $this->response(data: $notification);
    }

    public function markAllRead()
    {
        auth('client')->user()->notifications()->where('seen', '0')->update(['seen' => '1']);

        return $this->response(message: __('lang.success'));
    }

    public function destroy($id)
    {
        auth('client')->user()->notifications()->where('id', $id)->delete();
        return $this->response(message: __('lang.success'));
    }

    public function count()
    {
        $data['notification_count'] = auth('client')->user()->notifications()->where('seen', '0')->count();

        return $this->response(data: $data);
    }
}
